<?php
//#######################################################################
// passmanage.php - password management tool
//
// $Date: 2003/08/13 23:04:20 $ $Revision: 1.4 $
//
// written By Daniel Doman (c) Daniel Doman 2003
//
// ddoman@panix.com
// 
// Feel free to use this program as an aid in password management. You may not resell
// this program and all open source licensing conditions apply. Say something nice
// if you use it. Let me know if you have any problems.
//
//
// Simple password management GUI
// Nothing fancy here. No world class code. Just convenience...
//
// by default: 
// 
// 1) Pass.php will look for .htaccess file in the current directory in 
//    the absence of passmanage.ini
//
//     e.g.. passfile = "/foo/fah/.htpasswd"
//
// 2) If you define path to the .htpasswd file in "passmanage.ini" 
//
// Other Options:
//    localhostonly     - restrict use to localhost user only - default true
//    subnetonly        - restrict use to users on same subnet - default true
//    allowmd5override  - allow user to override MD5 setting - default true (see below)
//    usemd5            - Force MD5 Encryption	- default false
//
// 3) Apache 1.3 and 2.x on Windows uses MD5 encryption with htpasswd.exe so
//    pass.php checks for local OS and defaults to MD5 encryption on Windows machines.
//    It does this by parsing the output of phpinfo() call and looking for words typical
//    in windows configuratins. Let me know if I missed any possible keywords.
//
// 4) You can override the MD5 default in the checkbox on the screen at any time
//    unless you prevent this by setting "allowmd5override = false"
//  
// 5) You can override the automatic check for OS by setting UseMD5 to true or false. This will make 
//    the default encryption MD5 or not regardless of the machine type. This can still be overridden using
//    the checkbox unless you make this readonly by using allowmd5override (see above)
//
//
//#######################################################################

$s=<<<EOS
<html>
<head>
	<title>Password management</title>
	<meta name="keywords" content="PHP, encryption, Apache, password, .htpassword, Daniel Doman, MD5">
	<meta name="description" content="Passmanage.php is a simple tooll that makes Apache password management easier by providing a GUI to add, delete and modify users in an .htaccess file">
	<meta author:"daniel doman, ddoman@panix.com" />
	<link href="../standard.css" rel="stylesheet" type="text/css">
</head>
</html>
EOS;
print($s);


$config = array(
'passfile'		=> '.htpasswd',
'localhostonly'	=>false,
'subnetonly'	=>false,
'subnetonly'	=>true,
'usemd5' 		=>false,
'allowmd5override' =>true,
);

 
$inifile = "passmanage.ini";

$UseMD5 = IsWindowsMachine(); 

LoadIni();

if(!CheckAddressPermission())
	die("You Do Not have Access To This Page!");
 


$Users = LoadInfo($config['passfile']);
$message= false;
 
if(array_key_exists('action',$_POST)) 
	$action = explode(" ",$_POST['action']);
		

 
if(isset($action) && is_array($action)) {

	if($config['allowmd5override'])
		if(array_key_exists('md5',$_POST))
			$UseMD5 =  strcmp($_POST['md5'],"MD5") ? false : true;
 
 	switch( strtolower($action[0])) {
		case 'add':
		 	$newuser = $_POST['newuser'];
		 	$newuser = trim($newuser);
 
		 	if(strlen($newuser) <=0)
		 	{
		 		$message = "bad user name:" . $_POST['newuser']; 
		 		break;
		 	}
		 	if(strcmp($_POST['pw'], $_POST['pw2'])) {
			 	$message ="passwords do not match!<br>No Change";
			 	break;
			}
			  
			$Users[$newuser] = encrypt_password($pw = $_POST['pw']); 
			Commit_Users($config['passfile'],$Users);
			break;
		case 'delete':
			 
			$OldUsers = $Users;
		 
			$deaduser= $_POST['username'];
			 
		 	foreach($OldUsers as $Name  =>$pw) {
		 		if(!strcmp($Name,$deaduser)) {
		 			$message = "$Name Deleted";
		 			continue;
		 		 }
		 		 $NewUsers[$Name] = $pw;
		 	 }
		 	if(isset($NewUsers) && count($NewUsers))
		 		$Users = $NewUsers;
		 	else
		 		$Users = false;	
		 	Commit_Users($config['passfile'],$Users);
		 
			break;
		case 'verify':
			 $checkuser = $_POST['username'];
		 	 $checkuser = trim($checkuser);
 
		 	 if(strlen($checkuser) <=0) 	 {
		 		$message = "No User Name";
		 		break;
		 	 }
			 if(strcmp($_POST['pw'], $_POST['pw2'])) {
			 	$message = "passwords do not match eachother!";
			 	break;
			}
			
			$pw = $_POST['pw'];
			
			if($UseMD5) {
				if(!strcmp($Users[$checkuser], md5($pw)))  
					$message = "Matching Password";
				else
					$message = "That was Not The Correct Password";
				 
				break;
			}

			$salt = substr($Users[$checkuser],0,2);
			$check = crypt($pw,$salt);
			 
 
			 
			 
			if(!strcmp($Users[$checkuser],$check))
				$message = "Matching Password";
			else	
				$message = "That was Not The Correct Password";
 			break; 	
 			
		case 'change':
			 $changeuser = $_POST['username'];
		 	 $changeuser = trim($changeuser);
 
		 	 if(strlen($changeuser) <=0) 	 {
		 		$message = "No User Name";
		 		break;
		 	 }
			 if(strcmp($_POST['pw'], $_POST['pw2'])) {
			 	$message = "passwords do not match!<br>No Change";
			 	break;
			 	}
			  $Users[$changeuser] = encrypt_password($pw = $_POST['pw']);
			Commit_Users($config['passfile'],$Users);
 			break;
 		default:
 			break;
	}
}

// reload from defaults
$UseMD5 = IsWindowsMachine(); 
LoadIni();

// re - read passfile
$Users = LoadInfo($config['passfile']);
ManageUsers($message, $Users);
exit();


function CheckAddressPermission() {
	global $config;
 
	$userip 	= $_SERVER['REMOTE_ADDR'];
	$serverip 	= explode('.',$_SERVER['SERVER_ADDR']);
 
			
	// if its local - thats good enough
	if(!strcmp($userip,"127.0.0.1"))
		return true;
		
	if($config['localhostonly'])
		return false;
		
	// check if subnet restriction	
	if(!$config['subnetonly'])
		return true;
	
	// check if they are on the same subnet	-- check first three only	
	$userip = explode('.', $userip);
 	for($i=0; $i < 3; $i++) {
 		 if($userip[$i] != $serverip[$i])
 			return false;
 	}
 	return true;
}


function Commit_Users($FileName, $Users) {
 
	$fp = fopen($FileName,"w");
	if(!$fp)
		die("Could not Open $FileName for writing!");
	if(is_array($Users) && count($Users)) {	
		foreach($Users as $Name =>$pw)
			fputs($fp, $Name.':'.$pw . "\n");
	}
	fclose($fp);	
 
}

function encrypt_password($pw) {
	global $UseMD5;
	$salt=0;
	
 	if($UseMD5) {
 		echo 'using MD5<br>'; 
 		return md5($pw);
 	}
 
	// Next part to generate a random salt with letters and/or numbers 
	mt_srand((double)microtime()*1000000); 
	$chars = array_merge(range('a','z'),range('A','Z'),range(0,9)); 
	for($i=0;$i<2;$i++) {
		$salt .= $chars[mt_rand(0,count($chars)-1)]; 
	}
	return crypt($pw,$salt); 

	
}
 

function LoadInfo($PassFile) {
	if(!file_exists($PassFile)) {
		return false;
	}

	$Lines = file($PassFile);
	
	foreach($Lines as $f) {
		$array = explode(":",$f);
		$user = $array[0];
		$pass = trim($array[1]);
		$passwords[$user] = $pass;
	}
  	if(isset($passwords)) {
		ksort($passwords);
		return $passwords;
 	}
 	return false;
}


function LoadIni() {
 	global $inifile;
 	global $config;
 	global $UseMD5;
 	
	$temp = parse_ini_file($inifile);
	foreach($temp as $key =>$val) {
		
		$key = strtolower($key);	
 
		if(array_key_exists($key,$config)) {
		$config[$key] = $val;
		}
	}
	if($config['usemd5'])
		$UseMD5 = true;
		
	return count($temp);
}


function IsWindowsMachine() {
	$winvals = array(
	"WINNT",
	"SYSTEM32",
	"Windows_NT",
	"Windows_XP",
	);

	// buffer so we can snatch output
	ob_start();
	phpinfo(16);
	$php_info = ob_get_contents();
	ob_end_clean();
	
	foreach($winvals as $val)
	
	if(false != strpos($php_info,$val))
		return true; 
		
	return false;	
}

function ManageUsers($message,$Users) {
	global $config; 
	global $UseMD5;
 
	$Md5readonly = $config['allowmd5override'];
	
	if(is_array($Users) && count($Users))
 		$num = count($Users);
 	else 
 		$num = 0;	
	 
	$SelectSize = max(2,$num);
	
	// list size num number of users or no more than 10
	if($SelectSize >10) 
		$SelectSize = 10;
 	
			
	 	
 
  	print('<form name="user" method="post" action="' . basename($_SERVER['PHP_SELF']) . ' "  >');
	if($num) {
		print("Users:<br>"); 
		print("<select  name=\"username\" size=\"$SelectSize\"  >");
		print('<option></option>');
		foreach($Users as $name =>$pass)
			print("<Option>$name</option>");
		
		print('</select>');
	}
	else
		print("Empty Password File:<br>");
		
	print('<br><br>');
	print('<label>New User </label><Input type="text" name="newuser" length=10><br>');
	print('<label>Password </Label><input type="text" name="pw" length=10>&nbsp;&nbsp;');
	print('<label>Password Confirm </Label><input type="password" name="pw2"  ><br>');
 	print('<label>Use MD5 Encryption</Label><input type="checkbox" name="md5" value="MD5"' .
 	 ($UseMD5 ? "CHECKED": "") . 
 	 ($config['allowmd5override'] ? "" : " DISABLED ") 	.  ' ><br>');
 	
	print("<p>");
	if($message) {
		print("<br>Last Message: $message<br><br>");
	}
	print("Managing: {$config['passfile']}<hr>");
	print('<input type="submit" name="action" value="Add User"  >&nbsp;');
	if($num) {
		print('<input type="submit" name="action" value="Delete User" onclick="return CheckDeleteuser();">&nbsp;');
		print('<input type="submit" name="action" value="Change Password"  >&nbsp;');
		print('<input type="submit" name="action" value="Verify Password"  >&nbsp;');
	}
	
 
	print('</form>');
	
$s=<<<EOJ
<script language="javascript">

 

function CheckDeleteuser() {
 
 	var index = document.user.username.options.selectedIndex;
 	if(index <=0) return false;
 	document.user.name.value = document.user.username.options[index].value;
 	document.user.action.value = "DELETE";
  
 	 return confirm('Delete ' + document.user.username.options[index].value + '?');

}

</script>
EOJ;
print($s);		
}

 
?>



